<?php
// application/models/Role_model.php
class Role_model extends CI_Model {
    public function create_role($role_name) {
        $this->db->insert('roles', ['name' => $role_name]);
    }

    public function get_all_roles() {
        return $this->db->get('roles')->result();
    }
    
    public function get_role_name($role_id) {
        $query = $this->db->get_where('roles', ['id' => $role_id]);
        $role = $query->row();
        return $role ? $role->name : null;
    }

    public function delete_role($role_id) {
        // Deleting role and associated permissions
        $this->db->delete('permissions', ['role_id' => $role_id]); // Delete associated permissions first
        $this->db->delete('roles', ['id' => $role_id]); // Then delete the role
    }
}