<?php
class User_model extends CI_Model {

	// Function to register a new user
	public function register_user($data) {
		// Hash the password before saving it
		$data['password'] = password_hash($data['password'], PASSWORD_DEFAULT);
		return $this->db->insert('users', $data);
	}

	// Function to check if the username exists
	public function username_exists($username) {
		$query = $this->db->get_where('users', ['username' => $username]);
		return $query->num_rows() > 0;
	}

	// Function to check if the email exists
	public function email_exists($email) {
		$query = $this->db->get_where('users', ['email' => $email]);
		return $query->num_rows() > 0;
	}

	// Function to log in a user
	public function login_user($username, $password) {
		$query = $this->db->get_where('users', ['username' => $username]);

		if ($query->num_rows() == 1) {
			$user = $query->row();
			// Verify password
			if (password_verify($password, $user->password)) {
				return $user;
			}
		}

		return false;
	}
}
?>
