<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Dashboard</title>
    <style>
        * {
            box-sizing: border-box;
            margin: 0;
            padding: 0;
        }

        body {
            font-family: 'Segoe UI', sans-serif;
            display: flex;
            height: 100vh;
            background-color: #f4f6f8;
        }

        nav {
            width: 250px;
            background-color: #2f3542;
            color: white;
            padding: 20px;
            flex-shrink: 0;
            display: flex;
            flex-direction: column;
            justify-content: space-between;
        }

        nav h3 {
            margin-bottom: 20px;
            font-size: 20px;
        }

        nav ul {
            list-style: none;
        }

        nav a {
            display: block;
            color: #dcdde1;
            padding: 10px 15px;
            border-radius: 6px;
            margin-bottom: 8px;
            text-decoration: none;
            transition: 0.2s ease;
        }

        nav a:hover {
            background-color: #57606f;
            color: #fff;
        }

        nav a.active {
            background-color: #3742fa;
            color: white;
        }

        main {
            flex: 1;
            padding: 30px;
            overflow-y: auto;
        }

        .logout {
            margin-top: 30px;
            display: block;
            background: #ff4757;
            color: white;
            text-align: center;
            padding: 10px;
            text-decoration: none;
            border-radius: 6px;
            transition: 0.2s ease;
        }

        .logout:hover {
            background: #e84118;
        }

        @media (max-width: 768px) {
            nav {
                width: 100%;
                height: auto;
                flex-direction: row;
                flex-wrap: wrap;
                justify-content: space-around;
                padding: 10px;
            }

            main {
                padding: 15px;
            }
        }
    </style>
</head>
<body>

    <nav>
        <div>
            <h3>Navigation</h3>
            <ul>
                <?php foreach ($sections as $s): ?>
                    <li>
                        <a href="<?= base_url((strpos($s, 'admin/') === false) ? 'dashboard/' . $s : $s) ?>">
                            <?= ucfirst(basename($s)) ?>
                        </a>
                    </li>
                <?php endforeach; ?>
            </ul>
        </div>

        <a class="logout" href="<?= base_url('auth/logout') ?>">Logout</a>
    </nav>

    <main>
        <?php
        if (!empty($content)) {
            $this->load->view($content);
        } else {
            echo "<p>No content found.</p>";
        }
        ?>
    </main>

</body>
</html>