<!DOCTYPE html>
<html>
<head><title>Manage Users</title></head>
<body>

<h3>Manage Users</h3>
<table border="1" cellpadding="10">
    <thead>
        <tr>
            <th>Name</th>
            <th>Email</th>
            <th>Role</th>
            <th>Status</th>
            <th>Actions</th>
        </tr>
    </thead>
    <tbody>
        <?php foreach ($users as $user): ?>
            <?php $encoded_id = base64_encode($user->id); ?>
            <tr>
                <td><?= $user->name ?></td>
                <td><?= $user->email ?></td>
                <td><?= $this->Role_model->get_role_name($user->role_id) ?></td>
                <td><?= $user->is_active ? 'Active' : 'Inactive' ?></td>
                <td>
                    <a href="<?= base_url('admin/edit_user/' . $encoded_id) ?>">Edit</a> |
                    <a href="<?= base_url('admin/delete_user/' . $encoded_id) ?>" onclick="return confirm('Are you sure you want to delete this user?')">Delete</a> |
                    
                    <?php if ($user->is_active): ?>
                        <a href="<?= base_url('admin/deactivate_user/' . $encoded_id) ?>" onclick="return confirm('Deactivate this user?')">Deactivate</a>
                    <?php else: ?>
                        <a href="<?= base_url('admin/activate_user/' . $encoded_id) ?>" onclick="return confirm('Activate this user?')">Activate</a>
                    <?php endif; ?>
                </td>
            </tr>
        <?php endforeach; ?>
    </tbody>
</table>

<a href="<?= base_url('admin/create_user') ?>">Create New User</a><br>
<a href="<?= base_url('dashboard') ?>">Back to Dashboard</a>

</body>
</html>