<!DOCTYPE html>
<html lang="en">
<head>
	<meta charset="UTF-8">
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<title>My To-Do List</title>
	<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>

<div class="container mt-5">
	<h2>My To-Do List</h2>

	<!-- Log Out Button -->
	<a href="<?php echo site_url('tasks/logout'); ?>" class="btn btn-danger mb-3">Log Out</a>

	<!-- Display Flash Message for Errors or Success -->
	<?php if ($this->session->flashdata('error')): ?>
		<div class="alert alert-danger"><?php echo $this->session->flashdata('error'); ?></div>
	<?php endif; ?>
	<?php if ($this->session->flashdata('success')): ?>
		<div class="alert alert-success"><?php echo $this->session->flashdata('success'); ?></div>
	<?php endif; ?>

	<!-- Task List -->
	<ul class="list-group">
		<?php foreach ($tasks as $task): ?>
			<li class="list-group-item">
				<?php echo $task->task_name; ?>
				<?php if ($task->status != 'completed'): ?>
					<a href="<?php echo site_url('tasks/complete/'.$task->id); ?>" class="btn btn-sm btn-success float-end ms-2">Complete</a>
				<?php endif; ?>
				<a href="<?php echo site_url('tasks/delete/'.$task->id); ?>" class="btn btn-sm btn-danger float-end">Delete</a>
			</li>
		<?php endforeach; ?>
	</ul>

	<!-- Add Task Form -->
	<form action="<?php echo site_url('tasks/add'); ?>" method="POST" class="mt-3">
		<div class="input-group">
			<input type="text" name="task_name" class="form-control" placeholder="New Task" required>
			<button class="btn btn-primary" type="submit">Add Task</button>
		</div>
	</form>

</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
